#ifndef __Main_cpp__
#define __Main_cpp__

#include <iostream>
#include "ParseArgs.h"
#include "NeuralPDEDriver.h"

int main(int argc,char* argv[])
{
	ParseArgs parse_args;
    parse_args.Add_String_Argument("-o","output","output path");
	parse_args.Add_Integer_Argument("-driver",1,"driver");
	parse_args.Add_Integer_Argument("-test",1,"driver");
	parse_args.Add_Integer_Argument("-lf",100,"last frame");
	parse_args.Add_Integer_Argument("-en",1,"example number");
	parse_args.Add_String_Argument("-data","data","data name");
	parse_args.Add_String_Argument("-name","","simulation name");
    parse_args.Parse(argc,argv);

	std::string output_dir=parse_args.Get_String_Value("-o");
	std::string data=parse_args.Get_String_Value("-data");
	std::string name=parse_args.Get_String_Value("-name");
	const int last_frame=parse_args.Get_Integer_Value("-lf");
	const int en=parse_args.Get_Integer_Value("-en");
	const int test=parse_args.Get_Integer_Value("-test");

	NeuralPDEDriver driver;
	driver.pde_opt.output_dir=output_dir;

	driver.Initialize();
	driver.Run();
}

#endif